"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.NATIVE_OVERHEAD = exports.NATIVE_UNWRAP_OVERHEAD = exports.NATIVE_WRAP_OVERHEAD = exports.TOKEN_OVERHEAD = exports.SINGLE_HOP_OVERHEAD = exports.COST_PER_HOP = exports.COST_PER_INIT_TICK = exports.BASE_SWAP_COST = exports.COST_PER_UNINIT_TICK = void 0;
const bignumber_1 = require("@ethersproject/bignumber");
const router_sdk_1 = require("@uniswap/router-sdk");
const sdk_core_1 = require("@uniswap/sdk-core");
const providers_1 = require("../../../providers");
// Cost for crossing an uninitialized tick.
exports.COST_PER_UNINIT_TICK = bignumber_1.BigNumber.from(0);
//l2 execution fee on optimism is roughly the same as mainnet
const BASE_SWAP_COST = (id) => {
    switch (id) {
        case sdk_core_1.ChainId.MAINNET:
        case sdk_core_1.ChainId.GOERLI:
        case sdk_core_1.ChainId.SEPOLIA:
        case sdk_core_1.ChainId.OPTIMISM:
        case sdk_core_1.ChainId.OPTIMISM_GOERLI:
        case sdk_core_1.ChainId.OPTIMISM_SEPOLIA:
        case sdk_core_1.ChainId.BNB:
        case sdk_core_1.ChainId.AVALANCHE:
        case sdk_core_1.ChainId.BASE:
        case sdk_core_1.ChainId.BASE_GOERLI:
        case sdk_core_1.ChainId.ZORA:
        case sdk_core_1.ChainId.ZORA_SEPOLIA:
        case sdk_core_1.ChainId.ROOTSTOCK:
        case sdk_core_1.ChainId.BLAST:
        case sdk_core_1.ChainId.ZKSYNC:
        case sdk_core_1.ChainId.WORLDCHAIN:
        case sdk_core_1.ChainId.UNICHAIN_SEPOLIA:
        case sdk_core_1.ChainId.UNICHAIN:
        case sdk_core_1.ChainId.BASE_SEPOLIA:
        case sdk_core_1.ChainId.MONAD_TESTNET: // TODO: double check on monad gas
        case sdk_core_1.ChainId.SONEIUM:
            return bignumber_1.BigNumber.from(2000);
        case sdk_core_1.ChainId.ARBITRUM_ONE:
        case sdk_core_1.ChainId.ARBITRUM_GOERLI:
        case sdk_core_1.ChainId.ARBITRUM_SEPOLIA:
            return bignumber_1.BigNumber.from(5000);
        case sdk_core_1.ChainId.POLYGON:
        case sdk_core_1.ChainId.POLYGON_MUMBAI:
            return bignumber_1.BigNumber.from(2000);
        case sdk_core_1.ChainId.CELO:
        case sdk_core_1.ChainId.CELO_ALFAJORES:
            return bignumber_1.BigNumber.from(2000);
        //TODO determine if sufficient
        case sdk_core_1.ChainId.GNOSIS:
            return bignumber_1.BigNumber.from(2000);
        case sdk_core_1.ChainId.MOONBEAM:
            return bignumber_1.BigNumber.from(2000);
    }
};
exports.BASE_SWAP_COST = BASE_SWAP_COST;
const COST_PER_INIT_TICK = (id) => {
    switch (id) {
        case sdk_core_1.ChainId.MAINNET:
        case sdk_core_1.ChainId.GOERLI:
        case sdk_core_1.ChainId.SEPOLIA:
        case sdk_core_1.ChainId.BNB:
        case sdk_core_1.ChainId.AVALANCHE:
            return bignumber_1.BigNumber.from(31000);
        case sdk_core_1.ChainId.OPTIMISM:
        case sdk_core_1.ChainId.OPTIMISM_GOERLI:
        case sdk_core_1.ChainId.OPTIMISM_SEPOLIA:
        case sdk_core_1.ChainId.BASE:
        case sdk_core_1.ChainId.BASE_GOERLI:
        case sdk_core_1.ChainId.ZORA:
        case sdk_core_1.ChainId.ZORA_SEPOLIA:
        case sdk_core_1.ChainId.ROOTSTOCK:
        case sdk_core_1.ChainId.BLAST:
        case sdk_core_1.ChainId.ZKSYNC:
        case sdk_core_1.ChainId.WORLDCHAIN:
        case sdk_core_1.ChainId.UNICHAIN_SEPOLIA:
        case sdk_core_1.ChainId.UNICHAIN:
        case sdk_core_1.ChainId.BASE_SEPOLIA:
        case sdk_core_1.ChainId.MONAD_TESTNET: // TODO: double check on monad gas
        case sdk_core_1.ChainId.SONEIUM:
            return bignumber_1.BigNumber.from(31000);
        case sdk_core_1.ChainId.ARBITRUM_ONE:
        case sdk_core_1.ChainId.ARBITRUM_GOERLI:
        case sdk_core_1.ChainId.ARBITRUM_SEPOLIA:
            return bignumber_1.BigNumber.from(31000);
        case sdk_core_1.ChainId.POLYGON:
        case sdk_core_1.ChainId.POLYGON_MUMBAI:
            return bignumber_1.BigNumber.from(31000);
        case sdk_core_1.ChainId.CELO:
        case sdk_core_1.ChainId.CELO_ALFAJORES:
            return bignumber_1.BigNumber.from(31000);
        case sdk_core_1.ChainId.GNOSIS:
            return bignumber_1.BigNumber.from(31000);
        case sdk_core_1.ChainId.MOONBEAM:
            return bignumber_1.BigNumber.from(31000);
    }
};
exports.COST_PER_INIT_TICK = COST_PER_INIT_TICK;
const COST_PER_HOP = (id) => {
    switch (id) {
        case sdk_core_1.ChainId.MAINNET:
        case sdk_core_1.ChainId.GOERLI:
        case sdk_core_1.ChainId.SEPOLIA:
        case sdk_core_1.ChainId.BNB:
        case sdk_core_1.ChainId.OPTIMISM:
        case sdk_core_1.ChainId.OPTIMISM_GOERLI:
        case sdk_core_1.ChainId.OPTIMISM_SEPOLIA:
        case sdk_core_1.ChainId.AVALANCHE:
        case sdk_core_1.ChainId.BASE:
        case sdk_core_1.ChainId.BASE_GOERLI:
        case sdk_core_1.ChainId.ZORA:
        case sdk_core_1.ChainId.ZORA_SEPOLIA:
        case sdk_core_1.ChainId.ROOTSTOCK:
        case sdk_core_1.ChainId.BLAST:
        case sdk_core_1.ChainId.ZKSYNC:
        case sdk_core_1.ChainId.WORLDCHAIN:
        case sdk_core_1.ChainId.UNICHAIN_SEPOLIA:
        case sdk_core_1.ChainId.UNICHAIN:
        case sdk_core_1.ChainId.BASE_SEPOLIA:
        case sdk_core_1.ChainId.MONAD_TESTNET: // TODO: double check on monad gas
        case sdk_core_1.ChainId.SONEIUM:
            return bignumber_1.BigNumber.from(80000);
        case sdk_core_1.ChainId.ARBITRUM_ONE:
        case sdk_core_1.ChainId.ARBITRUM_GOERLI:
        case sdk_core_1.ChainId.ARBITRUM_SEPOLIA:
            return bignumber_1.BigNumber.from(80000);
        case sdk_core_1.ChainId.POLYGON:
        case sdk_core_1.ChainId.POLYGON_MUMBAI:
            return bignumber_1.BigNumber.from(80000);
        case sdk_core_1.ChainId.CELO:
        case sdk_core_1.ChainId.CELO_ALFAJORES:
            return bignumber_1.BigNumber.from(80000);
        case sdk_core_1.ChainId.GNOSIS:
            return bignumber_1.BigNumber.from(80000);
        case sdk_core_1.ChainId.MOONBEAM:
            return bignumber_1.BigNumber.from(80000);
    }
};
exports.COST_PER_HOP = COST_PER_HOP;
const SINGLE_HOP_OVERHEAD = (_id) => {
    return bignumber_1.BigNumber.from(15000);
};
exports.SINGLE_HOP_OVERHEAD = SINGLE_HOP_OVERHEAD;
const TOKEN_OVERHEAD = (id, route) => {
    const currencies = route.protocol === router_sdk_1.Protocol.V4 ? route.currencyPath : route.tokenPath;
    let overhead = bignumber_1.BigNumber.from(0);
    if (id == sdk_core_1.ChainId.MAINNET) {
        // AAVE's transfer contains expensive governance snapshotting logic. We estimate
        // it at around 150k.
        if (currencies.some((t) => t.equals(providers_1.AAVE_MAINNET))) {
            overhead = overhead.add(150000);
        }
        // LDO's reaches out to an external token controller which adds a large overhead
        // of around 150k.
        if (currencies.some((t) => t.equals(providers_1.LIDO_MAINNET))) {
            overhead = overhead.add(150000);
        }
    }
    return overhead;
};
exports.TOKEN_OVERHEAD = TOKEN_OVERHEAD;
// TODO: change per chain
const NATIVE_WRAP_OVERHEAD = (id) => {
    switch (id) {
        default:
            return bignumber_1.BigNumber.from(27938);
    }
};
exports.NATIVE_WRAP_OVERHEAD = NATIVE_WRAP_OVERHEAD;
const NATIVE_UNWRAP_OVERHEAD = (id) => {
    switch (id) {
        default:
            return bignumber_1.BigNumber.from(36000);
    }
};
exports.NATIVE_UNWRAP_OVERHEAD = NATIVE_UNWRAP_OVERHEAD;
const NATIVE_OVERHEAD = (chainId, amount, quote) => {
    if (amount.isNative) {
        // need to wrap eth in
        return (0, exports.NATIVE_WRAP_OVERHEAD)(chainId);
    }
    if (quote.isNative) {
        // need to unwrap eth out
        return (0, exports.NATIVE_UNWRAP_OVERHEAD)(chainId);
    }
    return bignumber_1.BigNumber.from(0);
};
exports.NATIVE_OVERHEAD = NATIVE_OVERHEAD;
//# sourceMappingURL=data:application/json;base64,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